/* Copyright_License {

  XCSoar Glide Computer - http://www.xcsoar.org/
  Copyright (C) 2000-2021 The XCSoar Project
  A detailed list of copyright holders can be found in the file "AUTHORS".

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; version 2
  of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
}
*/

#ifndef ANDROID_USBSERIALHELPER_H
#define ANDROID_USBSERIALHELPER_H

#include <jni.h>

class PortBridge;

namespace UsbSerialHelper {

/**
 * Global initialisation.  Looks up the methods of the
 * UsbSerialHelper Java class.
 */
bool
Initialise(JNIEnv *env) noexcept;

void
Deinitialise(JNIEnv *env) noexcept;

/**
 * Is the Usb Host available
 */
[[gnu::pure]]
bool
isEnabled(JNIEnv *env) noexcept;

/**
 * Returns a list of connected usb devices.
 */
jobjectArray
list(JNIEnv *env) noexcept;

PortBridge *
connectDevice(JNIEnv *env, const char *name, unsigned baud) noexcept;

};

#endif //ANDROID_USBSERIALHELPER_H
