import subprocess

from build.project import Project

def configure(toolchain, src, build, args=()):
    cross_args = []

    if toolchain.is_windows:
        cross_args.append('-DCMAKE_SYSTEM_NAME=Windows')
        cross_args.append('-DCMAKE_RC_COMPILER=' + toolchain.windres)

    # Several targets need a sysroot to prevent pkg-config from
    # looking for libraries on the build host (TODO: fix this
    # properly); but we must not do that on Android because the NDK
    # has a sysroot already
    if '-android' not in toolchain.actual_arch:
        cross_args.append('-DCMAKE_SYSROOT=' + toolchain.install_prefix)

    configure = [
        'cmake',
        src,

        '-DCMAKE_INSTALL_PREFIX=' + toolchain.install_prefix,
        '-DCMAKE_BUILD_TYPE=release',

        '-DCMAKE_C_COMPILER=' + toolchain.cc,
        '-DCMAKE_CXX_COMPILER=' + toolchain.cxx,

        '-DCMAKE_C_FLAGS=' + toolchain.cflags + ' ' + toolchain.cppflags,
        '-DCMAKE_CXX_FLAGS=' + toolchain.cxxflags + ' ' + toolchain.cppflags,

        '-GNinja',
    ] + cross_args + args

    subprocess.check_call(configure, env=toolchain.env, cwd=build)

class CmakeProject(Project):
    def __init__(self, url, alternative_url, md5, installed, configure_args=[],
                 windows_configure_args=[],
                 **kwargs):
        Project.__init__(self, url, alternative_url, md5, installed, **kwargs)
        self.configure_args = configure_args
        self.windows_configure_args = windows_configure_args

    def configure(self, toolchain):
        src = self.unpack(toolchain)
        build = self.make_build_path(toolchain)
        configure_args = self.configure_args
        if toolchain.is_windows:
            configure_args = configure_args + self.windows_configure_args
        configure(toolchain, src, build, configure_args)
        return build

    def build(self, toolchain):
        build = self.configure(toolchain)
        subprocess.check_call(['ninja', 'install'],
                              cwd=build, env=toolchain.env)
