// SPDX-License-Identifier: GPL-2.0-or-later
// Copyright The XCSoar Project

#pragma once

/**
 * @see http://developer.android.com/reference/android/view/KeyEvent.html
 */
enum {
  KEY_UP = 0x13,
  KEY_DOWN = 0x14,
  KEY_LEFT = 0x15,
  KEY_RIGHT = 0x16,
  KEY_VOLUME_UP = 0x18,
  KEY_VOLUME_DOWN = 0x19,
  KEY_TAB = 0x3d,
  KEY_SPACE = 0x3e,
  KEY_RETURN = 0x42,
  KEY_MENU = 0x52,
  KEY_ESCAPE = 0x6f,

  KEYCODE_BUTTON_R1 = 0x67,
  KEYCODE_BUTTON_R2 = 0x69,
  KEYCODE_BUTTON_L1 = 0x66,
  KEYCODE_BUTTON_L2 = 0x68,
  KEYCODE_BUTTON_A = 0x60,
  KEYCODE_BUTTON_B = 0x61,
  KEYCODE_BUTTON_C = 0x62,
  KEYCODE_BUTTON_X = 0x63,
  KEYCODE_BUTTON_Y = 0x64,
  KEYCODE_BUTTON_Z = 0x65,
  KEYCODE_MEDIA_NEXT = 0x57,
  KEYCODE_MEDIA_PREVIOUS = 0x58,
  KEYCODE_MEDIA_PLAY_PAUSE = 0x55,

  KEY_DUMMY = 0x80,
  KEY_BACK,
  KEY_HOME,
  KEY_END,
  KEY_PRIOR,
  KEY_NEXT,
  KEY_F1 = 0x83,
  KEY_F2 = 0x84,
  KEY_F3 = 0x85,
  KEY_F4 = 0x86,
  KEY_F5 = 0x87,
  KEY_F6 = 0x88,
  KEY_F7 = 0x89,
  KEY_F8 = 0x8a,
  KEY_F9 = 0x8b,
  KEY_F10 = 0x8c,
  KEY_F11 = 0x8d,
  KEY_F12 = 0x8e,
  KEY_APP1,
  KEY_APP2,
  KEY_APP3,
  KEY_APP4,
  KEY_APP5,
  KEY_APP6,
};
