
# Privacy Policy

This document describes the XCSoar privacy policy for an application operated
and provided by the current project maintainer ([Max Kellermann]). It describes
what personal information we may be gathering from you, who can see this
information, and what options you have for controlling this.

[Max Kellermann]: mailto:max@kellermann.name

For the protection of the XCSoar and other users, if you do not agree with this
Privacy Policy, you may not use the application.

## Community development

Development of XCSoar is a community effort, with many developers involved and
work taking place on many separate components.  Generally XCSoar operates
offline and only logs the data needed for purpose of competition soaring.  The
following descriptions are a de facto accumulation of this into a 'privacy
policy' describing how we work with the data.

You should always view the XCSoar application with a questioning mind, and feel
free to raise any concerns you have about matters of privacy by contacting us
via [GitHub issue tracker](https://github.com/XCSoar/issues).

## Types of Information We Receive From You, How We Get It, & How We Use It

### Information Related to Your Use of XCSoar

XCSoar is an offline logging app. We don't collect any information from your
usage of the app.

### Information We Receive Automatically

XCSoar can download additional resources from a central
[repository](https://download.xcsoar.org/) This includes:

- waypoints
- airspace files
- maps

Accessing the 'File Manager' service will log your IP Address on the web server
in the log. Resources contained in the File Manager Repository may be hosted
by 3rd Parties. Downloading these Resources will result in log entries at these
sites.

### Information We Collect

XCSoar does log sensor information while the app is running, even when in the background.
Depending on the attached sensors this may include:

- location information (GPS)
- pressure sensors such as true air speed, or barometric
- system information such as battery voltage or airframe switches
- nearby traffic information from collision warning systems such as FLARM
- gyro and accelerometer data

XCSoar logs this data offline in IGC (and optionally NMEA) files and does not
send this information anywhere.

For location data there are online tracking functions that have to be
registered / enabled and configured explicitly:

- [skylines](https://skylines.aero)
- [livetrack24](https://livetrack24.com)
- [cloud.xcsoar.net](https://cloud.xcsoar.net)

For information on their Privacy policy please see the respective service.

### Location Information

Your location information is recorded into an Fédération Aéronautique
Internationale Gliding Commission standard log file, short (IGC).

This happens offline and unless you share this file from your device, your
location data is not sent anywhere.

## When We May Share Your Information

### With Your Permission

We don't have your information and therefore cannot access or share it.

### For Legal Reasons

We don't have your information and therefore cannot access or share it.

### To Protect You, Ourselves & Others

We don't have your information and therefore cannot access or share it.

### To Our Service Providers

## Protection

### How your Data is Protected

We are a Free Software Project. As such there is no interest in your data.
Therefore we do not collect it or send it anywhere.

### How Long is your Data retained

Your data is saved on the device you run XCSoar on. The logs are not erased
unless you do so.

---
The text of this Privacy Policy is available under the
[Creative Commons Attribution-ShareAlike License][CC-BY-SA] and was adapted from
the [Wikipedia Privacy Policy].

[CC-BY-SA]: https://creativecommons.org/licenses/by-sa/3.0/
[Wikipedia Privacy Policy]: https://wikimediafoundation.org/wiki/Privacy_policy
