/*
Copyright_License {

  XCSoar Glide Computer - http://www.xcsoar.org/
  Copyright (C) 2000-2022 The XCSoar Project
  A detailed list of copyright holders can be found in the file "AUTHORS".

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
}
*/

#pragma once

#include "BlackboardListener.hpp"
#include "LiveBlackboard.hpp"

#include <functional>
#include <cassert>

/**
 * A dummy class that implements all abstract methods as no-ops.
 * Inherit this class and only implement the methods you're interested
 * in.
 */
class ScopeCalculatedListener : public NullBlackboardListener {
public:
  typedef std::function<void(const MoreData &basic,
                             const DerivedInfo &calculated)> Function;

private:
  LiveBlackboard &blackboard;
  Function function;

public:
  ScopeCalculatedListener(LiveBlackboard &_blackboard, Function _function)
    :blackboard(_blackboard), function(_function) {
    assert(function);

    blackboard.AddListener(*this);
  }

  ~ScopeCalculatedListener() {
    blackboard.RemoveListener(*this);
  }

  virtual void OnCalculatedUpdate(const MoreData &basic,
                                  const DerivedInfo &calculated) override;
};
