/*
Copyright_License {

  XCSoar Glide Computer - http://www.xcsoar.org/
  Copyright (C) 2000-2015 The XCSoar Project
  A detailed list of copyright holders can be found in the file "AUTHORS".

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
}
*/

#include "Screen/Init.hpp"
#include "Screen/Debug.hpp"
#include "Screen/Font.hpp"
#include "Event/Globals.hpp"
#include "Event/Queue.hpp"
#include "Asset.hpp"

#ifdef ENABLE_OPENGL
#include "Screen/OpenGL/Init.hpp"
#endif

#include <SDL.h>
#if SDL_MAJOR_VERSION >= 2
#include <SDL_hints.h>
#endif

#include <stdio.h>
#include <stdlib.h>

ScreenGlobalInit::ScreenGlobalInit()
{
  Uint32 flags = SDL_INIT_VIDEO;
  if (!IsKobo())
    flags |= SDL_INIT_AUDIO;

  if (::SDL_Init(flags) != 0) {
    fprintf(stderr, "SDL_Init() has failed: %s\n", ::SDL_GetError());
    exit(EXIT_FAILURE);
  }

#if defined(HAVE_GLES) && SDL_MAJOR_VERSION >= 2
  SDL_GL_SetAttribute(SDL_GL_CONTEXT_PROFILE_MASK, SDL_GL_CONTEXT_PROFILE_ES);
#ifdef HAVE_GLES2
  SDL_GL_SetAttribute(SDL_GL_CONTEXT_MAJOR_VERSION, 2);
  SDL_GL_SetAttribute(SDL_GL_CONTEXT_MINOR_VERSION, 0);
#endif
#endif

#if SDL_MAJOR_VERSION >= 2
  // Keep screen on (works on iOS, and maybe for other platforms)
  SDL_SetHint(SDL_HINT_IDLE_TIMER_DISABLED, "1");
#endif

  if (HasTouchScreen())
    SDL_ShowCursor (SDL_FALSE);

#if SDL_MAJOR_VERSION < 2
  ::SDL_EnableKeyRepeat(250, 50);
  ::SDL_EnableUNICODE(true);
#endif

#if defined(ENABLE_OPENGL)
  ::SDL_GL_SetAttribute(SDL_GL_DOUBLEBUFFER, 1);
  ::SDL_GL_SetAttribute(SDL_GL_STENCIL_SIZE, 1);

  OpenGL::Initialise();
#endif

  Font::Initialise();

  event_queue = new EventQueue();

  ScreenInitialized();
}

ScreenGlobalInit::~ScreenGlobalInit()
{
  delete event_queue;
  event_queue = nullptr;

#ifdef ENABLE_OPENGL
  OpenGL::Deinitialise();
#endif

  Font::Deinitialise();

  ::SDL_Quit();

  ScreenDeinitialized();
}
