/*
Copyright_License {

  XCSoar Glide Computer - http://www.xcsoar.org/
  Copyright (C) 2000-2013 The XCSoar Project
  A detailed list of copyright holders can be found in the file "AUTHORS".

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
}
*/

#include "MarkerRenderer.hpp"
#include "Projection/WindowProjection.hpp"
#include "Look/MarkerLook.hpp"
#include "Markers/ProtectedMarkers.hpp"
#include "Markers/Markers.hpp"

static void
RenderMarkers(Canvas &canvas, const WindowProjection &projection,
              const MarkerLook &look, const Markers &markers)
{
  for (const Marker &m : markers) {
    RasterPoint pt;
    if (projection.GeoToScreenIfVisible(m.location, pt))
      look.icon.Draw(canvas, pt);
  }
}

void
RenderMarkers(Canvas &canvas, const WindowProjection &projection,
              const MarkerLook &look, const ProtectedMarkers &markers)
{
  const ProtectedMarkers::Lease lease(markers);
  RenderMarkers(canvas, projection, look, lease);
}
