/*
Copyright_License {

  XCSoar Glide Computer - http://www.xcsoar.org/
  Copyright (C) 2000-2013 The XCSoar Project
  A detailed list of copyright holders can be found in the file "AUTHORS".

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
}
*/

#include "DebugPort.hpp"
#include "Device/Port/Port.hpp"
#include "Device/Port/ConfiguredPort.hpp"
#include "Device/Driver/Vega/Internal.hpp"
#include "OS/Args.hpp"
#include "Profile/DeviceConfig.hpp"
#include "Operation/ConsoleOperationEnvironment.hpp"
#include "IO/Async/GlobalIOThread.hpp"

#include <stdio.h>
#include <string.h>

int main(int argc, char **argv)
{
  Args args(argc, argv, "PORT BAUD [NAME=VALUE] [NAME] ...");
  const DeviceConfig config = ParsePortArgs(args);

  InitialiseIOThread();

  Port *port = OpenPort(config, *(DataHandler *)NULL);
  if (port == NULL) {
    fprintf(stderr, "Failed to open COM port\n");
    return EXIT_FAILURE;
  }

  VegaDevice device(*port);

  ConsoleOperationEnvironment env;

  while (!args.IsEmpty()) {
    const char *p = args.GetNext();
    char *q = strdup(p);
    char *v = strchr(q, '=');
    if (v == NULL) {
      if (!device.RequestSetting(q, env))
        printf("Error\n");
    } else {
      *v++ = 0;
      if (!device.SendSetting(q, atoi(v), env))
        printf("Error\n");
    }

    free(q);
  }

  delete port;
  DeinitialiseIOThread();
  return EXIT_SUCCESS;
}
