/*
Copyright_License {

  XCSoar Glide Computer - http://www.xcsoar.org/
  Copyright (C) 2000-2013 The XCSoar Project
  A detailed list of copyright holders can be found in the file "AUTHORS".

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
}
*/

#ifndef XCSOAR_AIRSPACE_CLASS_RENDERER_SETTINGS_PANEL_HPP
#define XCSOAR_AIRSPACE_CLASS_RENDERER_SETTINGS_PANEL_HPP

#include "Widget/RowFormWidget.hpp"
#include "Form/ActionListener.hpp"
#include "Airspace/AirspaceClass.hpp"
#include "Renderer/AirspaceRendererSettings.hpp"

class AirspaceClassRendererSettingsPanel:
  public RowFormWidget, ActionListener
{
  enum ControlIndex {
    BorderColor,
    FillColor,
    FillBrush,
    BorderWidth,
    FillMode,
  };

  bool border_color_changed;
  bool fill_color_changed;
  bool fill_brush_changed;
  AirspaceClass type;
  AirspaceClassRendererSettings settings;

public:
  AirspaceClassRendererSettingsPanel(AirspaceClass type);

  virtual void Prepare(ContainerWindow &parent, const PixelRect &rc) override;
  virtual bool Save(bool &changed, bool &require_restart) override;

protected:
  /* methods from ActionListener */
  virtual void OnAction(int id) override;

private:
  void FillAirspaceClasses();
};

#endif
